<?php

namespace Blocksy;

class DemoInstallPluginsUninstaller {
	public function import() {
		if (! current_user_can('edit_theme_options')) {
			wp_send_json_error([
				'message' => __("Sorry, you don't have permission to uninstall plugins.", 'blocksy-companion')
			]);
		}

		// phpcs:ignore WordPress.Security.NonceVerification.Recommended
		if (empty($_REQUEST['plugins'])) {
			wp_send_json_success();
		}

		// phpcs:ignore WordPress.Security.NonceVerification.Recommended
		$plugins = explode(':', sanitize_text_field(wp_unslash($_REQUEST['plugins'])));

		$plugins_manager = Plugin::instance()->demo->get_plugins_manager();

		foreach ($plugins as $single_plugin) {
			$plugins_manager->plugin_deactivation($single_plugin);
		}

		wp_send_json_success();
	}
}


